/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.api.feature.EnumMode;
import doggytalents.client.screen.StringEntrySelectScreen;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.AllStandSwitchModeData;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class AllStandSwitchModeScreen
extends StringEntrySelectScreen {
    private List<EnumMode> modeList = List.of();
    private Player player;

    protected AllStandSwitchModeScreen(Player player) {
        super((Component)Component.m_237119_());
        this.player = player;
    }

    public static void open(Player user) {
        List<EnumMode> modeList = Arrays.stream(EnumMode.VALUES).filter(x -> !x.canWander()).collect(Collectors.toList());
        Minecraft mc = Minecraft.m_91087_();
        AllStandSwitchModeScreen screen = new AllStandSwitchModeScreen(user);
        mc.m_91152_((Screen)screen);
        screen.setModeList(modeList);
    }

    public void setModeList(List<EnumMode> modeList) {
        if (modeList == null) {
            return;
        }
        this.modeList = modeList;
        Function<EnumMode, String> str_getter = mode_to_get -> {
            String unloc = mode_to_get.getUnlocalisedName();
            return I18n.m_118938_((String)unloc, (Object[])new Object[0]);
        };
        List<String> modeList_str = this.modeList.stream().map(str_getter).collect(Collectors.toList());
        this.updateEntries(modeList_str);
    }

    @Override
    protected void onEntrySelected(int id) {
        EnumMode selected_mode = this.modeList.get(id);
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new AllStandSwitchModeData(selected_mode));
        Minecraft mc = this.f_96541_;
        if (mc != null) {
            mc.m_91152_(null);
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

